; AutoIt Script File
; http://www.autoitscript.com
;
; Authors: Mr Chris, Mathias Berchtold <mb@smartftp.com>

; Do not show tray icon when AutoIt starts
#NoTrayIcon
#requireadmin

; Imports the registry settings.
RunWait (@ComSpec & ' /c reg import PortableSmartFTP.reg', '', @SW_HIDE)

; For Custom Commands, History, Recent Folders, Transfer Queue and Cache
DirCreate(@ScriptDir & '\AppData')
RegWrite("HKEY_CURRENT_USER\SOFTWARE\SmartFTP\Client 2.0\Settings\General", "Application Data Folder", "REG_EXPAND_SZ", @ScriptDir & '\AppData' )

; Default Download Folder
;$user_desktop = @UserProfileDir & '\Desktop'
;RegWrite("HKEY_CURRENT_USER\SOFTWARE\SmartFTP\Client 2.0\Settings\General", "Default Download Folder", "REG_EXPAND_SZ", $user_desktop )

; Favorites
DirCreate(@ScriptDir & '\Favorites')
RegWrite("HKEY_CURRENT_USER\SOFTWARE\SmartFTP\Client 2.0\Settings\General\Favorites", "Personal Favorites", "REG_EXPAND_SZ",  @ScriptDir & '\Favorites' )

; Backup Folder
DirCreate(@ScriptDir & '\Backup')
RegWrite("HKEY_CURRENT_USER\SOFTWARE\SmartFTP\Client 2.0\Settings\Backup", "Folder", "REG_EXPAND_SZ",  @ScriptDir & '\Backup' )

; register all shell extensions
RunWait (@ComSpec & ' /c regsvr32.exe /s sfTransferQueue.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /s sfPidlStorage.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /s sfFTPShellExtension.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /s sfFavoritesShellExtension.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /s sfShellTools.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /s sfFavorites.dll', '', @SW_HIDE)

Runwait (@ScriptDir & '\SmartFTP.exe /register')

; Opens SmartFTP Client
Runwait (@ScriptDir & '\SmartFTP.exe')

Runwait (@ScriptDir & '\SmartFTP.exe /unregister')

; unregister all shell extensions
RunWait (@ComSpec & ' /c regsvr32.exe /u /s sfTransferQueue.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /u /s sfPidlStorage.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /u /s sfFTPShellExtension.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /u /s sfFavoritesShellExtension.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /u /s sfShellTools.dll', '', @SW_HIDE)
RunWait (@ComSpec & ' /c regsvr32.exe /u /s sfFavorites.dll', '', @SW_HIDE)

; This line will export all registry settings for the application, That way any changes made while the application
; was open can be saved and or used for next time SmartFTP is launched.
RunWait(@ComSpec & ' /c reg export "HKCU\Software\SmartFTP\Client 2.0" PortableSmartFTP.reg', '', @SW_HIDE)

; Deletes the registry settings when program is closed.
RunWait (@ComSpec & ' /c reg delete "HKCU\Software\SmartFTP\Client 2.0" /f', '', @SW_HIDE)
